***************** Instructions for the creation of the text file with the data that can be uploaded on WINBUGS
use dataset_06_08.dta, clear
replace year=1 if year==2006
replace year=2 if year==2008

gen cons=1
wbarray risk left_right education gender age proximity country year cons, format(%12.1f %12.0f %12.0f %12.0f %12.0f %12.3f %12.0f %12.0f %12.0f) ///
saving(data.txt, replace)

exit

***************** Instructions for the creation of the text files with the initial values that can be uploaded on WINBUGS
clear all
set obs 36993

* initials for variances (same across chains)
gen tau_b1=1 in 1/27
gen tau_b2=1 in 1/27
gen tau_b3=1 in 1/27
gen tau_b4=1 in 1/27
gen tau_b5=1 in 1/27
gen tau_b6=1 in 1/27
gen tau_u1=1 in 1/27
gen tau_u2=1 in 1/2
scalar tau_mu=1

** First chain: inits_chain1.txt
* initials for betas
set seed 1
gen b1=-1+(2*runiform()) in 1/27
gen b2=-1+(2*runiform()) in 1/27
gen b3=-1+(2*runiform()) in 1/27
gen b4=-1+(2*runiform()) in 1/27
gen b5=-1+(2*runiform()) in 1/27
gen b6=-1+(2*runiform()) in 1/27
* initials for country intercepts
gen u1=-1+(2*runiform()) in 1/27
gen u2=-1+(2*runiform()) in 1/2

wbdata, c(wbvector tau_b1 if tau_b1!=. + wbvector tau_b2 if tau_b2!=. + wbvector tau_b3 if tau_b3!=. + wbvector tau_b4 if tau_b4!=. ///
+ wbvector tau_b5 if tau_b5!=. + wbvector tau_b6 if tau_b6!=. ///
+ wbvector tau_u1 if tau_u1!=. + wbvector tau_u2 if tau_u2!=. + wbscalar , sca(tau_mu) ///
+ wbvector b1 if b1!=. + wbvector b2 if b2!=. + wbvector b3 if b3!=. + wbvector b4 if b4!=. + wbvector b5 if b5!=. + wbvector b6 if b6!=. ///
+ wbvector u1 if u1!=. + wbvector u2 if u2!=. ) saving(inits_chain1.txt, replace)

drop b* u*

** Second chain: inits_chain2.txt
* initials for betas
set seed 2
gen b1=-1+(2*runiform()) in 1/27
gen b2=-1+(2*runiform()) in 1/27
gen b3=-1+(2*runiform()) in 1/27
gen b4=-1+(2*runiform()) in 1/27
gen b5=-1+(2*runiform()) in 1/27
gen b6=-1+(2*runiform()) in 1/27
* initials for country intercepts
gen u1=-1+(2*runiform()) in 1/27
gen u2=-1+(2*runiform()) in 1/2

wbdata, c(wbvector tau_b1 if tau_b1!=. + wbvector tau_b2 if tau_b2!=. + wbvector tau_b3 if tau_b3!=. + wbvector tau_b4 if tau_b4!=. ///
+ wbvector tau_b5 if tau_b5!=. + wbvector tau_b6 if tau_b6!=. ///
+ wbvector tau_u1 if tau_u1!=. + wbvector tau_u2 if tau_u2!=. + wbscalar , sca(tau_mu) ///
+ wbvector b1 if b1!=. + wbvector b2 if b2!=. + wbvector b3 if b3!=. + wbvector b4 if b4!=. + wbvector b5 if b5!=. + wbvector b6 if b6!=. ///
+ wbvector u1 if u1!=. + wbvector u2 if u2!=. ) saving(inits_chain2.txt, replace)

drop b* u*

** Third chain: inits_chain3.txt
* initials for betas
set seed 3
gen b1=-1+(2*runiform()) in 1/27
gen b2=-1+(2*runiform()) in 1/27
gen b3=-1+(2*runiform()) in 1/27
gen b4=-1+(2*runiform()) in 1/27
gen b5=-1+(2*runiform()) in 1/27
gen b6=-1+(2*runiform()) in 1/27
* initials for country intercepts
gen u1=-1+(2*runiform()) in 1/27
gen u2=-1+(2*runiform()) in 1/2

wbdata, c(wbvector tau_b1 if tau_b1!=. + wbvector tau_b2 if tau_b2!=. + wbvector tau_b3 if tau_b3!=. + wbvector tau_b4 if tau_b4!=. ///
+ wbvector tau_b5 if tau_b5!=. + wbvector tau_b6 if tau_b6!=. ///
+ wbvector tau_u1 if tau_u1!=. + wbvector tau_u2 if tau_u2!=. + wbscalar , sca(tau_mu) ///
+ wbvector b1 if b1!=. + wbvector b2 if b2!=. + wbvector b3 if b3!=. + wbvector b4 if b4!=. + wbvector b5 if b5!=. + wbvector b6 if b6!=. ///
+ wbvector u1 if u1!=. + wbvector u2 if u2!=. ) saving(inits_chain3.txt, replace)

